%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Statistical Analyis of data %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Principal components of tranche price changes
data = [IG5Y_tranches.market_upfront_mid(:,1) IG5Y_tranches.market_price_mid(:,2:end)];
data = diff(data);
data_std = mapstd(data')';
[coefs,scores,variances] = princomp(data_std);
cumsum(variances)/length(variances)
component_history = data_std * coefs;
plot(cumsum(scores(:,1:3)))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Define sample cds and index structure for testing %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Define a sample CDS (time series object)
ajd_dynamics = struct('k', 0.2, 'theta', 0.02, 'sigma', 0.01, 'L', 0.2, 'mu',0.03);
ajd_dynamics2 = struct('k', 0.2, 'theta', 0.01, 'sigma', 1e-5, 'L', 1e-10, 'mu', 1e-10);
ajd_dynamics3 = struct('k', 4.7259, 'theta', 0.0299, 'sigma', 0.0070, 'L', 1.3454, 'mu',0.0312);
cds_test = struct('company', 'test', 'dates', {{datenum({'05/01/2006' '05/02/2006'}) datenum({'05/02/2006'})}}, 'market_price', {{[200; 300] [325]}}, ...
                  'T', {{[5.1361; 5.1333] [7.1361]}}, 'bid_ask_spread', {{[10; 5] [15]}}, 'model_price', {{[-1; -1] [-1]}}, 'x0', [0.01; 0.03], ...
                  'AJD', ajd_dynamics, 'LGD', 0.6, 'ai', 1);
discount_curves_test = struct('dates', {datenum({'05/01/2006'; '05/02/2006'})}, ...
                              'discounts', { exp( -0.05 * repmat(0.25:0.25:10, 2, 1) ) }, ...
                              'discounts_inbetween', { exp( -0.05 * repmat((0.25:0.25:10)-1/8, 2, 1) ) }, ...
                              'horizon', {(0.25:0.25:10)'}, 'horizon_inbetween', {(0.25:0.25:10)'-1/8} );
cdx_test = struct( ...
    'dates', {{datenum({'05/01/2006' '05/02/2006'}) datenum({'05/02/2006'})}}, 'T', {{[4.8861; 4.8833] [6.8861]}}, 'cut_offs', {[0.03 0.07 0.1 0.15 0.3]}, ...
    'index_market_price', {{[78; 85] [125]}}, ...
    'tranche_market_price_mid', {{repmat([500 71 15.5 8 4.5], 2, 1) [500 91 17.5 11 7.5]}}, ...
    'tranche_market_upfront_mid', {{repmat([0.245 0 0 0 0], 2, 1) [0.345 0 0 0 0]}}, ...
    'portfolio', [cds_test cds_test cds_test cds_test cds_test]', ...
    'AJD_common_factor', ajd_dynamics, 'y0', [0.01; 0.01], ...
    'index_members', {[1 1 1 1 1; 1 1 1 1 0]} ...
);                           

% Test the different functions to calculate survival probabilities
test = struct('k', 0.0013, 'theta', 0.0020, 'sigma', 0.0121, 'L', 0.0294, 'mu', 0.0503);
surv_prob_c(0.001, test, 0:0.25:5)
surv_prob_c2(0.001, test, 5)
surv_prob_c3(0.001, 0.0013, 0.0020, 0.0121, 0.0294, 0.0503, 5);

% Test different functions for calculating the portfolio loss distribution
test = port_loss_dist(cdx_test.dates{1}, [0:0.25:5; 0:0.25:5], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000);
test2 = port_loss_dist2(cdx_test.dates{1}, [0:0.25:5; 0:0.25:5], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000);
test3 = port_loss_dist_interpolate(cdx_test.dates{1}, [0:0.25:5; 0:0.25:5], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000, 4);
test4 = port_loss_dist_interpolate(cdx_test.dates{1}, [0:0.25:5; 0:0.25:5], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000, 1);

% Evalute quality model implied tranche prices for interpolated portfolio loss distribution
[trash, test] = wrapper_tranche_mispricing(get_x0(cdx_new1), cdx_new1, discounts_IMM, datenum('02/01/2006'), datenum('02/01/2006'), 2000, 0.7, [1 0 0 0], [1 0 0], 1, 1);
% Quarterly: 500.0000  112.3642   21.2473   11.9681    2.0203
% Half year: 500.0000  112.3417   21.2339   11.9588    2.0187
% Yearly: 500.0000  112.2664   21.1827   11.9231    2.0123
% Two & 1/2 years: 500.0000  112.9241   21.0419   11.6901    1.9810
% Five year: 500.0000  123.0487   22.5330   12.8481    2.2109

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Singe name CDS pricing %
%%%%%%%%%%%%%%%%%%%%%%%%%%

% Update CDS with model implied price
cds_test = update_model_price_cds(cds_test, discounts_IMM);

% Update CDS with model implied initial default intensity
cds_test = update_model_x0(cds_test, discounts_IMM);

% Test for ACE
cds_ACE = CDX_NA_IG.portfolio(1);
cds_ACE.AJD = ajd_dynamics;
cds_ACE.LGD = 0.6;
profile on;
cds_ACE = update_model_x0(cds_ACE, discounts_IMM);
plot(cds_ACE.x0)
profile viewer;
cds_ACE = update_model_price_cds(cds_ACE, discounts_IMM);

%%%%%%%%%%%%%%%%%
% Index Pricing %
%%%%%%%%%%%%%%%%%

% Update index with model implied price (for each date and index maturity)
cdx_test = update_model_price_index(cdx_test, discounts_IMM);       

%%%%%%%%%%%%%%%%%%%
% Tranche Pricing %
%%%%%%%%%%%%%%%%%%%

% Calculate portfolio loss distribution for various dates and horizons simultaneously
port_loss_dist(cdx_test.dates{1}, [1 5; 2 4], cdx_test.portfolio, cdx_test.index_members, [0.01; 0.01], ajd_dynamics, 1000)

% Compare the two different versions of calculating survival probabilities
surv_prob([0.01; 0.02], ajd_dynamics, [0.15:0.25:4.9; 0.25:0.25:5]);    % need to go into directory 'old'
surv_prob_c([0.01; 0.02], ajd_dynamics, [0.15:0.25:4.9; 0.25:0.25:5]);
surv_prob_c2([0.01; 0.02], ajd_dynamics, [4.9; 5]);

% Compare speed between implementation in Matlab and C++ (old implementations in directory 'old')
tic; cond_loss_dist(repmat(0.01, 1, 125)); toc;
tic; cond_loss_dist_c(repmat(0.01, 1, 125)); toc;

tic; cond_loss_dist(repmat(0.1, 500, 125)); toc;
tic; cond_loss_dist_c(repmat(0.1, 500, 125)); toc;

tic; surv_prob((0:0.01:0.1)', ajd_dynamics, repmat((0.25:0.25:5), 11, 1)); toc;
tic; surv_prob_c((0:0.01:0.1)', ajd_dynamics, repmat((0.25:0.25:5), 11, 1)); toc;

tic; surv_prob((0:(1/500):1)', ajd_dynamics, repmat((0.25:0.25:10), 501, 1)); toc;
tic; surv_prob_c((0:(1/500):1)', ajd_dynamics, repmat((0.25:0.25:10), 501, 1)); toc;

% Update CDX with model implied prices
profile on;
cdx_test = update_model_price_tranches(cdx_test, discounts_IMM, 1000, datenum('05/01/2006'), datenum('05/02/2006'));
profile viewer;

% Update CDX with model implied initial intensity of common factor
profile on;
update_model_y0(CDX_NA_IG2_monthly, discounts_IMM, 1000, 0.7, datenum('10/02/2006'), datenum('11/01/2006'), [1 0 0])
profile viewer;
