function TS_new = TS_bipower_covariation(TS1, TS2)
% --------------------------------------------------------------------------------------------------
% Calculate bipower covariation for two time series.
% --------------------------------------------------------------------------------------------------
% TS1           ... first time series
% TS2           ... second time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS1 = TS_return(struct('values', CDX_NA_IG2.portfolio(1).intensity_P, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 3);
    TS2 = TS_return(struct('values', CDX_NA_IG2.portfolio(2).intensity_P, 'dates', CDX_NA_IG2.portfolio(2).dates{1}), 3);
    TS_bipower_covariation(TS1, TS2)
%}
% --------------------------------------------------------------------------------------------------

% If less than two dates available for one of the TS, return empty TS
if (isempty(TS1)) | (isempty(TS2)) | (length(TS1.values) < 2) | (length(TS2.values) < 2)
    TS_new = [];
    return;
end

% Calculate bipower variation
TS_bp_sum = TS_bipower_variation(TS_add_TS(TS1, TS2));
TS1_bp = TS_bipower_variation(TS1);
TS2_bp = TS_bipower_variation(TS2);
TS_new = TS_mult_double(TS_add_TS(TS_bp_sum, TS_mult_double(TS_add_TS(TS1_bp, TS2_bp), -1)), 0.5);