function TS_new = TS_bipower_variation(TS)
% --------------------------------------------------------------------------------------------------
% For a given (usually return) time series, calculate the bipower variation time series.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% --------------------------------------------------------------------------------------------------
% sample call: TS_bipower_variation(TS_return(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 3))
% --------------------------------------------------------------------------------------------------

% If less than two dates available, return empty TS
if (isempty(TS)) | (length(TS.values) < 2)
    TS_new = [];
    return;
end

% Calculate bipower variation
values = abs(TS.values);
values = cumsum(values(1:end-1) .* values(2:end));
TS_new = struct('dates', TS.dates(2:end), 'values', values);