function TS_new = TS_correlation_TS(TS1, TS2, method_2nd, param_2nd)
% --------------------------------------------------------------------------------------------------
% Calculate the rolling correlation of two (usually return-) time series: First, bring time series
% onto same date scale, then calculate rolling estimate of correlation of returns. The new dates
% will be the union of the dates in TS1 and TS2.
% --------------------------------------------------------------------------------------------------
% TS1           ... first time series
% TS2           ... second time series
% method_2nd    ... method by which to calculate second moments:
%                   1 = empirical second moment of last 'param_2nd' data points
%                   2 = use exponentially weighted moving average with decay factor 'param_2nd', e.g. 0.95
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_correlation_TS(TS_return(TS_vector, 3), 1, 40)
    TS_correlation_TS(TS_return(TS_vector, 3), 2, 0.975)
%}
% --------------------------------------------------------------------------------------------------

% Calculating rolling covariance & volatilites
TS_cov = TS_covariance_TS(TS1, TS2, method_2nd, param_2nd);
TS1_vol = TS_volatility(TS1, method_2nd, param_2nd);
TS2_vol = TS_volatility(TS2, method_2nd, param_2nd);

% Divide by volatilities to get rolling correlation
TS_new = TS_divide_TS(TS_cov, TS_mult_TS(TS1_vol, TS2_vol));