function TS_new = TS_correlation_TS_level(TS1, TS2, method_ret, method_2nd, param_2nd)
% --------------------------------------------------------------------------------------------------
% Calculate the rolling correlation of the changes in two time series: First, bring time series
% onto same date scale, then calculate returns, then calculate rolling estimate of correlation of
% returns. The new dates will be the union of the dates in TS1 and TS2.
% --------------------------------------------------------------------------------------------------
% TS1           ... first time series
% TS2           ... second time series
% method_ret    ... method by which to calculate returns
%                   1 ... absolute returns
%                   2 ... relative returns
%                   3 ... log_returns
% method_2nd    ... method by which to calculate second moments:
%                   1 = empirical second moment of last 'param_2nd' data points
%                   2 = use exponentially weighted moving average with decay factor 'param_2nd', e.g. 0.95
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_correlation_TS_level(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), ...
                             struct('values', CDX_NA_IG2.portfolio(2).market_price{1}, 'dates', CDX_NA_IG2.portfolio(2).dates{1}), 3, 1, 40)
    TS_correlation_TS_level(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), ...
                             struct('values', CDX_NA_IG2.portfolio(2).market_price{1}, 'dates', CDX_NA_IG2.portfolio(2).dates{1}), 3, 2, 0.975)
%}
% --------------------------------------------------------------------------------------------------

% Synchronize time series
tmp = TS_vector_synchronize({TS1; TS2});
TS1 = tmp{1};
TS2 = tmp{2};

% Calculate return time series
TS1 = TS_return(TS1, method_ret);
TS2 = TS_return(TS2, method_ret);

% Calculating rolling covariance matrix
TS_new = TS_correlation_TS(TS1, TS2, method_2nd, param_2nd);