function TS_new = TS_covariance_TS_level(TS1, TS2, method_ret, method_2nd, param_2nd)
% --------------------------------------------------------------------------------------------------
% Calculate the rolling covariance of the CHANGES of two level time series: First, bring time series
% onto same date scale, then calculate returns, then calculate rolling estimate of covariance of
% returns. The new dates will be the union of the dates in TS1 and TS2.
% --------------------------------------------------------------------------------------------------
% TS1           ... first time series
% TS2           ... second time series
% method_ret    ... method by which to calculate returns:
%                   1 ... absolute returns
%                   2 ... relative returns
%                   3 ... log_returns
% method_2nd    ... method by which to calculate second moments:
%                   1 = empirical second moment of last 'param_2nd' data points
%                   2 = use exponentially weighted moving average with decay factor 'param_2nd', e.g. 0.95
%                   3 = robust estimator based on median of sqrt(abs(values1*value2)) during last 'param_2nd' days
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_covariance_TS_level(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), ...
                           struct('values', CDX_NA_IG2.portfolio(2).market_price{1}, 'dates', CDX_NA_IG2.portfolio(2).dates{1}), 3, 1, 20)
%}
% --------------------------------------------------------------------------------------------------

if isempty(TS1) | isempty(TS2)
    TS_new = [];
    return;
end

% Bring both TS onto same date scale
all_dates = union_sorted_c(TS1.dates, TS2.dates);
TS1 = TS_sample(TS1, all_dates);
TS2 = TS_sample(TS2, all_dates);

% Calculate changes in values & their product
TS1 = TS_return(TS1, method_ret);
TS2 = TS_return(TS2, method_ret);

% Calculate rolling covariance estimate
TS_new = TS_covariance_TS(TS1, TS2, method_2nd, param_2nd);
