function TS_new = TS_delta_t(TS, lag)
% --------------------------------------------------------------------------------------------------
% Return a time series with the actual number of days between the data points.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% lag       ... indicator, whether to lag observations by one data point, default: no
% --------------------------------------------------------------------------------------------------
% sample call: TS_delta_t(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}))
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    TS_new = [];
    return;
end

if (nargin < 2)
    lag = 0;
end

% Return empty TS if number of data points <= 1
if (length(TS.values) <= 1)
    TS_new = struct('dates', [], 'values', []);
    return;
end

% Calculate actual number of days between data points
delta_t = daysact(TS.dates(1:end-1), TS.dates(2:end));
if (lag == 0)
    TS_new = struct('dates', TS.dates(2:end), 'values', delta_t);
else
    TS_new = struct('dates', TS.dates(1:end-1), 'values', delta_t);
end