function TS_new = TS_divide_TS(TS1, TS2)
% --------------------------------------------------------------------------------------------------
% Divide TS1 by TS2. The new dates will be the union of the dates in TS1 and TS2.
% --------------------------------------------------------------------------------------------------
% TS1       ... first time series
% TS2       ... second time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_divide_TS(struct('values', [1 5]', 'dates', [732211 732647]'), struct('values', [2 2 4]', 'dates', [732210 732211 732646]'))
%}
% --------------------------------------------------------------------------------------------------

% Return sum of time series
divide = @(x) 1./x;
TS_new = TS_mult_TS(TS1, TS_function(TS2, divide));