function TS_new = TS_divide_double(TS, x)
% --------------------------------------------------------------------------------------------------
% Divide the times series values by a double.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% x         ... number by which to divide time series values values
% --------------------------------------------------------------------------------------------------
% sample call: TS_divide_double(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 2.7)
% --------------------------------------------------------------------------------------------------

TS_new = struct('dates', TS.dates, 'values', TS.values / x);