function TS_new = TS_ewma(TS, alpha)
% --------------------------------------------------------------------------------------------------
% Calculate exponentially weighted moving average of a time series.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% alpha     ... decay factor in exponentially moving average => weights = alpha.^(t-s)
% --------------------------------------------------------------------------------------------------
% sample call: TS_ewma(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 0.95)
% --------------------------------------------------------------------------------------------------

% Do nothing if there are less than two values in the time series
if (isempty(TS)) | (length(TS.values) < 2)
    TS_new = TS;
    return;
end

% Calculate EWMA time series
ewma = TS.values;
weights = ones(length(ewma), 1);
for t=2:length(ewma)
   ewma(t) = ewma(t) + alpha * ewma(t-1);
   weights(t) = 1 + alpha * weights(t-1);
end
ewma = ewma ./ weights;
TS_new = struct('dates', TS.dates, 'values', ewma);