function TS_new = TS_exponentiate(TS)
% --------------------------------------------------------------------------------------------------
% Take the exponential of the time series values
% --------------------------------------------------------------------------------------------------
% TS       ... first time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_exponentiate(struct('values', [1 5]', 'dates', [732211 732647]'))
%}
% --------------------------------------------------------------------------------------------------

% Return sum of time series
TS_new = struct('dates', TS.dates, 'values', exp(TS.values));