function TS_new = TS_function(TS, func, args)
% --------------------------------------------------------------------------------------------------
% Apply an arbitrary function (with optional parameters) to the values in a time series
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% func      ... function to be applied to time series values
% args      ... optional arguments to function
% --------------------------------------------------------------------------------------------------
% sample call: TS_function(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), @sqrt)
% --------------------------------------------------------------------------------------------------

% Do nothing if time series is empty
if isempty(TS)
    TS_new = TS;
    return;
end

% Apply function to TS
if (nargin == 2)
    TS_new = struct('dates', TS.dates, 'values', func(TS.values));
else
    TS_new = struct('dates', TS.dates, 'values', func(TS.values, args));
end