function TS_new = TS_lag(TS, method, param)
% --------------------------------------------------------------------------------------------------
% Calculate lagged time series
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% method    ... method by which to lag observations:
%               1 ... by 'param' days
%               2 ... by 'param' observations
% param     ... length of lag in days/observations
% --------------------------------------------------------------------------------------------------
% sample call: TS_lag(TS1, 1, 1)
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    TS_new = [];
    return;
end

if (method == 1)
    % Shift dates by 'param' days into the future
    new_dates = daysadd(TS.dates, param);
    TS_new = struct('dates', new_dates, 'values', TS.values);
elseif (method == 2)
    % If lag-length longer than time series, return empty TS
    if (param >= length(TS.values))
        TS_new = [];
        return;
    end
    
    % Lag observations
    values_new = TS.values(1:end-param);
    dates_new = TS.dates((param+1):end);
    TS_new = struct('dates', dates_new, 'values',values_new);
end