function log_LH = TS_likelihood_fixed_params(x0, TS, kernel, display)
% --------------------------------------------------------------------------------------------------
% Wrapper function for 'TS_likelihood' with time-fixed parameters
% --------------------------------------------------------------------------------------------------
% x0            ... [k,theta,sigma,L,mu]
% TS            ... structure with values and dates
% kernel        ... type of transition kernel
%                   1 ... affine jump diffusion AJD(k,theta,sigma,L,mu)
% display       ... whether to display likelihood, default: yes
% --------------------------------------------------------------------------------------------------
% sample call: TS_likelihood_fixed_params([0.02; 0.02; 0.05; 0.1; 0.2], TS, 1);
% --------------------------------------------------------------------------------------------------

if (nargin < 4)
    display = 1;
end
params = struct('k', x0(1), 'theta', x0(2), 'sigma', x0(3), 'L', x0(4), 'mu', x0(5), 'dates', datenum('01/01/2000'));
log_LH = TS_likelihood(TS, kernel, params);
if (display == 1)
    disp(['x0: ' num2str(x0')]);
    disp(['negative log-LH: ' num2str(log_LH)]);
end