function log_LH = TS_likelihood_fixed_params_log(x0, TS, kernel)
% --------------------------------------------------------------------------------------------------
% Wrapper function for 'TS_likelihood_fixed_params' with transformed paraters, that make the Feller
% conditions a linear constraint.
% --------------------------------------------------------------------------------------------------
% x0        ... [log(k),log(theta),log(sigma),L,mu]
% TS        ... structure with values and dates
% kernel    ... type of transition kernel
%               1 ... affine jump diffusion AJD(k,theta,sigma,L,mu)
% --------------------------------------------------------------------------------------------------
% sample call: TS_likelihood_fixed_params_log([log(0.02); log(0.02); log(0.05); 0.1; 0.2], TS, 1);
% --------------------------------------------------------------------------------------------------

x0(1:3) = exp(x0(1:3)); 
log_LH = TS_likelihood_fixed_params(x0, TS, kernel);
