function log_LH = TS_likelihood_fixed_params_partial(x0, AJD, TS, kernel, display)
% --------------------------------------------------------------------------------------------------
% Wrapper function for 'TS_likelihood' with time-fixed parameters (k,L,mu) & externally given
% time-varying parameters (k*theta)_t, sigma_t
% --------------------------------------------------------------------------------------------------
% x0            ... [k,L,mu]
% AJD           ... AJD parameter time series
% TS            ... structure with values and dates
% kernel        ... type of transition kernel
%                   1 ... affine jump diffusion AJD(k,theta,sigma,L,mu)
% display       ... whether to display likelihood, default: yes
% --------------------------------------------------------------------------------------------------
% sample call: TS_likelihood_fixed_params_partial([0.02; 0.1; 0.2], TS, 1);
% --------------------------------------------------------------------------------------------------

if (nargin < 4)
    display = 1;
end
params = AJD;
params.theta = params.k .* params.theta / x0(1);
params.k = repmat(x0(1), length(AJD.dates), 1);
params.L = repmat(x0(2), length(AJD.dates), 1);
params.mu = repmat(x0(3), length(AJD.dates), 1);

log_LH = TS_likelihood(TS, kernel, params);
if (display == 1)
    disp(['x0: ' num2str(x0')]);
    disp(['negative log-LH: ' num2str(log_LH)]);
end