function log_LH = TS_likelihood_fixed_params_partial3(x0, AJD, TS, kernel, display)
% --------------------------------------------------------------------------------------------------
% Wrapper function for 'TS_likelihood' with time-fixed parameters (k,omega5,omega4), where mu_i^P =
% omega4 * X_it and l_i^P = omega5 * X_it. The parameters are constant over time, while (k*theta)_t,
% sigma_t are externally given and time varying.
% --------------------------------------------------------------------------------------------------
% x0            ... [k,omega5,omega4]
% AJD           ... AJD parameter time series
% TS            ... structure with values and dates
% kernel        ... type of transition kernel
%                   1 ... affine jump diffusion AJD(k,theta,sigma,L,mu)
% display       ... whether to display likelihood, default: yes
% --------------------------------------------------------------------------------------------------
% sample call: TS_likelihood_fixed_params_partial3([0.02; 0.1; 0.2], TS, 1);
% --------------------------------------------------------------------------------------------------

if (nargin < 4)
    display = 1;
end
params = AJD;
params.theta = params.k .* params.theta / x0(1);
params.k = repmat(x0(1), length(AJD.dates), 1);
% Determine jump intensity time series
if (1)
    params.L = zeros(length(AJD.dates), 1);
    
    % Determine insertion pos
    [trash, pos] = intersect_sorted(AJD.dates, TS.dates);
    params.L(pos) = x0(2) * [TS.values(1); TS.values(1:end-1)];
end
% Determine expected jump size time series
if (1)
    params.mu = zeros(length(AJD.dates), 1);
    
    % Determine insertion pos
    [trash, pos] = intersect_sorted(AJD.dates, TS.dates);
    params.mu(pos) = x0(3) * [TS.values(1); TS.values(1:end-1)];
end

log_LH = TS_likelihood(TS, kernel, params);
if (display == 1)
    disp(['x0: ' num2str(x0')]);
    disp(['negative log-LH: ' num2str(log_LH)]);
end