function [TS_vector_ev, TS_lambda] = TS_matrix_SVD(TS_matrix, dates, normalization)
% --------------------------------------------------------------------------------------------------
% For a TS_matrix, calculate the rank-one SVD approximation at points in time 'dates' and store the
% results in a TS_vector (for singular vectors) and regular TS (for first singular value).
% --------------------------------------------------------------------------------------------------
% TS_matrix     ... TS matrix object
% dates         ... dates at which to calculate SVD
% normalization ... how to normalize factor loadings:
%                   1 ... mean equal to one
%                   2 ... median equal to one
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    [TS_vector_ev, TS_lambda] = TS_matrix_SVD(TS_full_cov, cdx_tv_quarterly.dates{1})
%}
% --------------------------------------------------------------------------------------------------

% Pre-allocate memory
n = size(TS_matrix, 1);
TS_vector_ev = cell(n,1);
TS_lambda = [];

% For each desired date, determine SVD
for i=1:length(dates)
    % Extract matrix of values for given date
    date = dates(i);
    if (mod(i,10) == 0)
        disp(datestr(date,23));
    end
    values = TS_matrix_sample1(TS_matrix, date);
    
    % Determine rank-one SVD approximation
    [u, v, lambda] = SVD_iterative(values, normalization);
    
    % Insert eigen-vector and eigen-value into time series
    TS_vector_ev = TS_matrix_merge(TS_vector_ev, TS_matrix_const(u, date));
    TS_lambda = TS_merge(TS_lambda, TS_const(lambda, date));
end
