function TS_matrix = TS_matrix_add_TS_matrix(TS_matrix1, TS_matrix2)
% --------------------------------------------------------------------------------------------------
% Calculate the sum of two TS_matrix objects
% --------------------------------------------------------------------------------------------------
% TS_matrix1    ... TS matrix object
% TS_matrix2    ... TS matrix object
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix_add_TS_matrix(TS_lambda_P_cov, TS_lambda_P_cov')
%}
% --------------------------------------------------------------------------------------------------

% Pre-allocate memory
[n, m] = size(TS_matrix1);
[n2, m2] = size(TS_matrix2);
if (n ~= n2) | (m ~= m2)
    error('Matrix dimensions do not match');
end
TS_matrix = cell(n, m);

% Add matrices (by first bringing entries (i,j) and (i',j') onto same date scale)
for i=1:n
    for j=1:m
        %disp(i);
        %disp(j);
        TS1 = TS_matrix1{i,j};
        TS2 = TS_matrix2{i,j};
        if isempty(TS1)
            TS_matrix{i,j} = TS2;
        elseif isempty(TS2)
            TS_matrix{i,j}= TS1;
        else
            TS_matrix{i,j} = TS_add_TS(TS1, TS2);
        end
    end
end