function TS_matrix = TS_matrix_const(values, date)
% --------------------------------------------------------------------------------------------------
% Initialize constant TS_matrix
% --------------------------------------------------------------------------------------------------
% values    ... matrix of values
% date      ... date after which TS_matrix exists
% --------------------------------------------------------------------------------------------------
% sample call: TS_matrix_const([3 1; 2 5], datenum('12/05/2005'))
% --------------------------------------------------------------------------------------------------

% Generate TS_matrix
[n,m] = size(values);
TS_matrix = cell(n, m);
for i=1:n
    for j=1:m
        if isempty(values(i,j))
            TS_matrix{i,j} = [];
        else
            TS_matrix{i,j} = TS_const(values(i,j), date);
        end
    end
end
