function TS_vector = TS_matrix_diag(TS_matrix)
% --------------------------------------------------------------------------------------------------
% Return the diagonal of a TS_matrix as a TS_vector
% --------------------------------------------------------------------------------------------------
% TS_matrix        ... cell matrix of time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix = {struct('values', [1 5]', 'dates', [732211 732647]')  [];
                 struct('values', [2.5 3.5]', 'dates', [732210 732648]')  []};
    TS_matrix_diag(TS_matrix)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS if TS_matrix is empty
if isempty(TS_matrix)
    TS_vector = [];
    return;
end

% Synchronize time series
TS_matrix = TS_matrix_synchronize(TS_matrix);

% Extract diagonal
TS_vector = {};
for i=1:size(TS_matrix,1)
    TS_vector{i} = TS_matrix{i,i};
end