function TS_matrix_new = TS_matrix_merge(TS_matrix1, TS_matrix2)
% --------------------------------------------------------------------------------------------------
% Merge two TS_matrix objects series. If same date shows up in both, use values from TS_matrix1.
% --------------------------------------------------------------------------------------------------
% TS_matrix1       ... TS matrix object
% TS_matrix2       ... TS matrix object
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix_merge(TS_lambda_P_cov,TS_lambda_P_cov)
%}
% --------------------------------------------------------------------------------------------------

% Pre-allocate memory
[n, m] = size(TS_matrix1);
[n2, m2] = size(TS_matrix2);
if (n ~= n2) | (m ~= m2)
    error('Matrix dimensions do not match');
end
TS_matrix_new = cell(n, m);

% Add matrices (by first bringing entries (i,j) and (i',j') onto same date scale)
for i=1:n
    for j=1:m
        TS1 = TS_matrix1{i,j};
        TS2 = TS_matrix2{i,j};
        TS_matrix_new{i,j} = TS_merge(TS1, TS2);
    end
end
