function TS_matrix_new = TS_matrix_mult_TS_matrix(TS_matrix, TS_matrix2)
% --------------------------------------------------------------------------------------------------
% Pointwise multiply two TS_matrix objects, i.e. multiply individual time series
% --------------------------------------------------------------------------------------------------
% TS_matrix        ... cell matrix of time series
% TS_matrix2       ... cell matrix of time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix = {struct('values', [1 5]', 'dates', [732211 732647]')  [];
                 struct('values', [2.5 3.5]', 'dates', [732210 732648]')  []};
    TS_matrix_mult_TS_matrix(TS_matrix, TS_matrix)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS if TS_matrix is empty
if isempty(TS_matrix)
    TS_matrix_new = [];
    return;
end

% Do TS multiplications
TS_matrix_new = cell(size(TS_matrix));
for i=1:size(TS_matrix,1)
    for j=1:size(TS_matrix,2)
        TS_matrix_new{i,j} = TS_mult_TS(TS_matrix{i,j}, TS_matrix2{i,j});
    end
end
