function mat = TS_matrix_sample1(TS_matrix, date, rows, cols)
% --------------------------------------------------------------------------------------------------
% Sample TS_matrix at a single point in time.
% --------------------------------------------------------------------------------------------------
% TS_matrix     ... TS matrix object
% date          ... date at which to sample values from matrix
% rows          ... which rows to sample, default: all
% cols          ... which cols to sample, default: same as rows
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix_sample1(TS_lambda_P_cov, datenum('12/05/2005'))
%}
% --------------------------------------------------------------------------------------------------

if (nargin < 3)
    rows = 1:size(TS_matrix,1);
end
if (nargin < 4)
    cols = rows;
end

% Extract data
n = length(rows);
m = length(cols);
mat = NaN(n, m);
for i=1:length(rows)
    for j=1:length(cols)
        if isempty(TS_matrix{rows(i), cols(j)})
            continue;
        end
        tmp = TS_sample(TS_matrix{rows(i), cols(j)}, date);
        if (~isempty(tmp.values))
            mat(i,j) = tmp.values;
        end
    end
end