function TS_new = TS_matrix_sum(TS_matrix)
% --------------------------------------------------------------------------------------------------
% Calculate the sum of all currently active time-series.
% --------------------------------------------------------------------------------------------------
% TS_matrix        ... cell matrix of time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix = {struct('values', [1 5]', 'dates', [732211 732647]')  [];
                 struct('values', [2.5 3.5]', 'dates', [732210 732648]')  []};
    TS_matrix_sum(TS_matrix)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS if TS_matrix is empty
if isempty(TS_matrix)
    TS_new = [];
    return;
end

% Synchronize time series
TS_matrix = TS_matrix_synchronize(TS_matrix);

% Calculate sum of active time series
sum_all = zeros(length(TS_matrix{1}.dates), 1);
for i=1:size(TS_matrix,1)
    for j=1:size(TS_matrix,2)
        if isempty(TS_matrix{i,j})
            continue;
        end
        ts_values = TS_matrix{i,j}.values;
        not_nan = ~isnan(ts_values);
        sum_all(not_nan) = sum_all(not_nan) + ts_values(not_nan);
    end
end

% Return time series with average
TS_new = struct('dates', TS_matrix{1}.dates, 'values', sum_all);