function TS_matrix = TS_matrix_synchronize(TS_matrix)
% --------------------------------------------------------------------------------------------------
% Synchronize the time series contained in a cell array
% --------------------------------------------------------------------------------------------------
% TS_matrix        ... matrix of time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_matrix = {struct('values', [1 5]', 'dates', [732211 732647]')  [];
                 struct('values', [2.5 3.5]', 'dates', [732210 732648]')  []};
    TS_matrix_synchronize(TS_matrix)
%}
% --------------------------------------------------------------------------------------------------

% Do nothing if we have less than two time series
if (length(TS_matrix) < 2)
    return;
end

% Determine all available dates;
all_dates = [];
for i=1:size(TS_matrix, 1)
    for j=1:size(TS_matrix, 2)
        if (~isempty(TS_matrix{i,j}))
            all_dates = union_sorted_c(all_dates, TS_matrix{i,j}.dates);
        end
    end
end

% Resample each time series at union of all dates
for i=1:size(TS_matrix, 1)
    for j=1:size(TS_matrix, 2)
        TS_matrix{i,j} = TS_sample(TS_matrix{i,j}, all_dates);
    end
end