function TS_new = TS_merge(TS1, TS2)
% --------------------------------------------------------------------------------------------------
% Merge two time series. If same date shows up in both, use values from TS1.
% --------------------------------------------------------------------------------------------------
% TS1       ... structure with values and dates
% TS2       ... time series to merge with TS1
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_merge(struct('values', [1 5]', 'dates', [732211 732647]'), struct('values', [2 2 4]', 'dates', [732210 732211 732646]'))
%}
% --------------------------------------------------------------------------------------------------

if isempty(TS1)
    TS_new = TS2;
    return;
elseif isempty(TS2)
    TS_new = TS1;
    return;
end

% Determine position of TS1 and TS2 dates in merged dates
all_dates = union_sorted_c(TS1.dates, TS2.dates);
pos_ts1 = logical(is_member_sorted_c(all_dates, TS1.dates));
pos_ts2 = logical(is_member_sorted_c(all_dates, TS2.dates));
values = zeros(length(all_dates), 1);
values(pos_ts2) = TS2.values;
values(pos_ts1) = TS1.values;

% Return merged time series
TS_new = struct('dates', all_dates, 'values', values);
