function TS_new = TS_min_TS(TS1, TS2)
% --------------------------------------------------------------------------------------------------
% Calculate the minimun of two time series.
% --------------------------------------------------------------------------------------------------
% TS1       ... first time series
% TS2       ... second time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_min_TS(struct('values', [1 5]', 'dates', [732211 732647]'), struct('values', [2 2 4]', 'dates', [732210 732211 732646]'))
%}
% --------------------------------------------------------------------------------------------------

% Bring both TS onto same date scale
all_dates = union_sorted_c(TS1.dates, TS2.dates);
TS1 = TS_sample(TS1, all_dates);
TS2 = TS_sample(TS2, all_dates);

% Return sum of time series
TS_new = struct('dates', all_dates, 'values', min(TS1.values, TS2.values));
