function TS_new = TS_minus_TS(TS1, TS2)
% --------------------------------------------------------------------------------------------------
% Substract TS2 from TS1. The new dates will be the union of the dates in TS1 and TS2.
% --------------------------------------------------------------------------------------------------
% TS1       ... first time series
% TS2       ... second time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_minus_TS(struct('values', [1 5]', 'dates', [732211 732647]'), struct('values', [2 2 4]', 'dates', [732210 732211 732646]'))
%}
% --------------------------------------------------------------------------------------------------

if isempty(TS1)
    TS_new = TS_mult_double(TS2, -1);
    return;
elseif isempty(TS2)
    TS_new = TS1;
    return;
end

% Bring both TS onto same date scale
all_dates = union_sorted_c(TS1.dates, TS2.dates);
TS1 = TS_sample(TS1, all_dates);
TS2 = TS_sample(TS2, all_dates);

% Return sum of time series
TS_new = struct('dates', all_dates, 'values', TS1.values - TS2.values);
