function TS_new = TS_moving_average(TS, m)
% --------------------------------------------------------------------------------------------------
% Calculate moving average of a time series.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% m         ... length of moving average (in data points)
% --------------------------------------------------------------------------------------------------
% sample call: TS_moving_average(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 10)
% --------------------------------------------------------------------------------------------------

% Do nothing if there are less than two values in the time series
if isempty(TS)
    TS_new = [];
    return;
elseif (length(TS.values) < 2)
    TS_new = TS;
    return;
end

% Calculate moving average time series
values = TS.values;
ma = values;
for j = 2:m
    values = [values(1); values(1:end-1);];
    ma = ma + values;
end
ma = ma / m;
TS_new = struct('dates', TS.dates, 'values', ma);