function TS_new = TS_mult_TS(varargin)
% --------------------------------------------------------------------------------------------------
% Recursively multiply two or more time series.
% --------------------------------------------------------------------------------------------------
% varargin  ... at least two time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS1 = struct('values', [1 5]', 'dates', [732211 732647]');
    TS2 = struct('values', [2 2 4]', 'dates', [732210 732211 732646]');
    TS_mult_TS(TS1, TS2, TS1)
%}
% --------------------------------------------------------------------------------------------------

% Extract first two input arguments
TS1 = varargin{1};
TS2 = varargin{2};

% Return product of time series
if isempty(TS1)
    TS_new = TS2;
    return;
elseif isempty(TS2)
    TS_new = TS1;
    return;
else
    % Bring both TS onto same date scale
    all_dates = union_sorted_c(TS1.dates, TS2.dates);
    TS11 = TS_sample(TS1, all_dates);
    TS22 = TS_sample(TS2, all_dates);    
    TS_new = struct('dates', all_dates, 'values', TS11.values .* TS22.values);
    if (nargin > 2)
        % If time series left, call function recursively
        TS_new = TS_mult_TS(TS_new, varargin{3:end});
    end
end