function TS_new = TS_mult_double(TS, x)
% --------------------------------------------------------------------------------------------------
% Multiply the times series values by a double.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% x         ... number by which to multiply values
% --------------------------------------------------------------------------------------------------
% sample call: TS_mult_double(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 2.7)
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    TS_new = TS;
else
    TS_new = struct('dates', TS.dates, 'values', TS.values * x);
end