function TS_plot(TS, log_scale, start_date, end_date)
% --------------------------------------------------------------------------------------------------
% Plot a times series.
% --------------------------------------------------------------------------------------------------
% TS            ... structure with values and dates
% log_sacle     ... indicator whether to plot y-axis on log-scale (not default)
% start_date    ... optional start_date of plot other than TS.dates(1) - useful for adding up plots
% end_date      ... optional end_date of plot other than TS.dates{end) - useful for adding up plots
% --------------------------------------------------------------------------------------------------
% sample call: TS_plot(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}))
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    disp('Cannot make plot since time-series is empty');
    return;
end
if (nargin < 2)
    log_scale = 0;
end
if (nargin < 3)
    start_date = TS.dates(1);
end
if (nargin < 4)
    end_date = TS.dates(end);
end

% Determine used date range
start_pos = find(TS.dates >= start_date, 1, 'first');
end_pos = find(TS.dates <= end_date, 1, 'last');
used_range = start_pos:end_pos;
used_dates = TS.dates(used_range);
used_values = TS.values(used_range);

% Make plot
dates_scale = used_dates - start_date;
if (log_scale == 1)
    semilogy(dates_scale, used_values, 'LineWidth', 1.2);
else
    plot(dates_scale, used_values, 'LineWidth', 1.2);
end

% Make nice axes & labels
%xlabel('Date')
make_nice_axis(gca, used_values);
make_nice_ticks(used_dates, 122);
%set(gca,'ytick', [0.1 0.2 0.5 1 2 5 10 20 50 100 200 500 1000]);