function TS_new = TS_power(TS, p)
% --------------------------------------------------------------------------------------------------
% Replace values by their p-th power in a time series
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% p         ... desired power
% --------------------------------------------------------------------------------------------------
% sample call: TS_power(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 2)
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    TS_new = TS;
else
    TS_new = struct('dates', TS.dates, 'values', TS.values.^p);
end