function TS_new = TS_quadratic_variation(TS)
% --------------------------------------------------------------------------------------------------
% For a given return time-series (usually mean zero), calculate quadratic variation
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% --------------------------------------------------------------------------------------------------
% sample call: TS_quadratic_variation(TS_return(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 3))
% --------------------------------------------------------------------------------------------------

% Calculate return time series
TS_new = struct('dates', TS.dates, 'values', cumsum(TS.values.^2));