function TS_new = TS_quadratic_variation_level(TS)
% --------------------------------------------------------------------------------------------------
% Generate the quadratic variation of a level time-series: First calculate returns, then calculate
% quadratic variation of returns.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% --------------------------------------------------------------------------------------------------
% sample call: TS_quadratic_variation_level(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}))
% --------------------------------------------------------------------------------------------------

% Convert time-series into returns
TS = TS_return(TS, 1);

% Calculate return time series
TS_new = struct('dates', TS.dates, 'values', cumsum(TS.values.^2));