function TS = TS_remove_NaN(TS)
% --------------------------------------------------------------------------------------------------
% Remove NaN values from a time series
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% --------------------------------------------------------------------------------------------------
% sample call: TS_remove_NaN(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}))
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    return;
end

missing = isnan(TS.values);
TS.dates = TS.dates(~missing);
TS.values = TS.values(~missing);
