function TS_new = TS_return(TS, method, delta_t)
% --------------------------------------------------------------------------------------------------
% Convert a time series into a return time series.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% method    ... method by which to calculate returns
%               1 ... absolute returns
%               2 ... relative returns
%               3 ... log_returns
% delta_t   ... indicator whether to also calculate delta_t for the return time series, default: no
% --------------------------------------------------------------------------------------------------
% sample call: TS_return(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 2)
% --------------------------------------------------------------------------------------------------

if (nargin < 3)
    delta_t = 0;
end

% Check if time series has at least two elements
if isempty(TS)
    TS_new = [];
    return;
end

% Calculate return time series
if (method == 1)
    returns = diff(TS.values);
elseif (method == 2)
    returns = TS.values(2:end) ./ TS.values(1:end-1) - 1;
elseif (method == 3)
    returns = log(TS.values(2:end) ./ TS.values(1:end-1));
end
TS_new = struct('values', returns, 'dates', TS.dates(2:end));

% Optionall also add delta_t
if (delta_t == 1)
    TS_dt = TS_delta_t(TS);
    TS_new.delta_t = TS_dt.values;
end