function TS_new = TS_rolling_median(TS, m)
% --------------------------------------------------------------------------------------------------
% Convert a time series into rolling median time series.
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% m         ... length of rolling median (in data points)
% --------------------------------------------------------------------------------------------------
% sample call: TS_rolling_median(struct('values', CDX_NA_IG2.portfolio(1).market_price{1}, 'dates', CDX_NA_IG2.portfolio(1).dates{1}), 10)
% --------------------------------------------------------------------------------------------------

% Check if time series has at least two elements
if length(TS. dates) <= 1
    TS_new = struct('values', [], 'dates', []);
    return;
end

% Calculate rolling median time series
values = rolling_median(TS.values, m);
TS_new = struct('values', values, 'dates', TS.dates);