function TS_new = TS_sub_period(TS, start_date_num, end_date_num)
% --------------------------------------------------------------------------------------------------
% Cut down time series to sub-period
% --------------------------------------------------------------------------------------------------
% TS                ... structure with values and dates
% start_date_num    ... desired start date of time series
% end_date_num      ... desired end date of time series
% --------------------------------------------------------------------------------------------------
% sample call:
%     TS_sub_period(TS_lambda, datenum('09/21/2004'), datenum('11/01/2006'))
% --------------------------------------------------------------------------------------------------

if isempty(TS)
    TS_new = TS;
    return
end

% Determine date range
start_pos = find(TS.dates >= start_date_num, 1, 'first');
if isempty(start_pos)
    start_pos = 1;
end
end_pos = find(TS.dates <= end_date_num, 1, 'last');
if isempty(end_pos)
    TS_new = [];
    return;
end

% Return sub-TS
used_range = start_pos:end_pos;
TS_new = struct('dates', TS.dates(used_range), 'values', TS.values(used_range));