function TS_new = TS_vector_average(TS_vector)
% --------------------------------------------------------------------------------------------------
% Calculate the average of all currently active time-series.
% --------------------------------------------------------------------------------------------------
% TS_vector        ... cell structure with multiple time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector = {struct('values', [1 5]', 'dates', [732211 732647]'); struct('values', [2.5 3.5]', 'dates', [732210 732648]')}
    TS_vector_average(TS_vector)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS if TS_vector is empty
if isempty(TS_vector)
    TS_new = [];
    return;
end

% Synchronize time series
TS_vector = TS_vector_synchronize(TS_vector);

% Calculate average time series
num_avg_used = zeros(length(TS_vector{1}.values), 1);
sum_all = zeros(length(TS_vector{1}.dates), 1);
for i=1:length(TS_vector)
    ts_values = TS_vector{i}.values;
    not_nan = ~isnan(ts_values);
    num_avg_used = num_avg_used + not_nan;          % keep track of number of doubles added at each date
    sum_all(not_nan) = sum_all(not_nan) + ts_values(not_nan);
end
values = sum_all ./ max(num_avg_used, 1);
values(num_avg_used == 0) = NaN;

% Return time series with average
TS_new = struct('dates', TS_vector{1}.dates, 'values', values);