function TS_matrix_new = TS_vector_covariance_level(TS_vector, method_ret, method_2nd, param_2nd)
% --------------------------------------------------------------------------------------------------
% Calculate rolling covariance time series of a vector of level time series: First bring time series
% pairwise(!) onto same scale, then calculate returns, then calculate covariances.
% --------------------------------------------------------------------------------------------------
% TS_vector     ... cell structure with multiple time series
% method_ret    ... method by which to calculate returns:
%                   1 ... absolute returns
%                   2 ... relative returns
%                   3 ... log_returns
% method_2nd    ... method by which to calculate second moments:
%                   1 = empirical second moment of last 'param_2nd' data points
%                   2 = use exponentially weighted moving average with decay factor 'param_2nd', e.g. 0.95
%                   3 = robust estimator based on median of sqrt(abs(values1*value2)) during last
%                   'param_2nd' days
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector_average(TS_vector, 3, 1, 20)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS_matrix if TS_vector is empty
if isempty(TS_vector)
    TS_matrix_new = {};
    return;
end

% Calculate covariance time series matrix
num_ts = length(TS_vector);
TS_matrix_new = cell(num_ts, num_ts);
for i=1:num_ts
    for j=i:num_ts
        % Calculate rolling covariance
        TS_matrix_new{i,j} = TS_covariance_TS_level(TS_vector{i}, TS_vector{j}, method_ret, method_2nd, param_2nd);
    end
end