function TS_new = TS_vector_levels2returns(TS_vector, method)
% --------------------------------------------------------------------------------------------------
% Convert a vector of level time series to a vector of return time series.
% --------------------------------------------------------------------------------------------------
% TS_vector     ... cell structure with multiple time series
% method        ... method by which to calculate returns
%               1 ... absolute returns
%               2 ... relative returns
%               3 ... log_returns
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector = {struct('values', [1 5]', 'dates', [732211 732647]'); struct('values', [2.5 3.5]', 'dates', [732210 732648]')}
    TS_vector_levels2returns(TS_vector, 3)
%}
% --------------------------------------------------------------------------------------------------

TS_new = TS_vector;
for i=1:length(TS_new)
    TS_new{i} = TS_return(TS_new{i}, method);
end