function log_LH = TS_vector_likelihood_fixed_params(x0, TS_vector, TS_vector_params_Q, display)
% --------------------------------------------------------------------------------------------------
% Compute the negative log-LH for a multi-dimensional time series.
% --------------------------------------------------------------------------------------------------
% x0                    ... [k^P, Avg_t(theta_it^Q)/theta_i^P, Avg_t(L_i^Q)/L_i^P, Avg_t(mu_i^Q)/mu_i^P]
% TS_vector             ... vector of time series
% TS_vector_params_Q    ... vector of parameter time series
% display               ... whether to display detailed summary statistics about LH
% --------------------------------------------------------------------------------------------------
% sample call: TS_vector_likelihood_fixed_params([0.05; 2; 2; 5], TS_vector, TS_vector_params_Q);
% --------------------------------------------------------------------------------------------------

% For each time series calculate Avg_t(theta_it^Q), Avg_t(L_i^Q) and Avg_t(mu_i^Q)
num_TS = length(TS_vector);
avg_t_theta_Q = zeros(num_TS, 1);
avg_t_L_Q = zeros(num_TS, 1);
avg_t_mu_Q = zeros(num_TS, 1);
for i=1:num_TS
    avg_t_theta_Q(i) = mean(TS_vector_params_Q{i}.theta);
    avg_t_L_Q(i) = mean(TS_vector_params_Q{i}.L);
    avg_t_mu_Q(i) = mean(TS_vector_params_Q{i}.mu);
end

% Calculate negative log-LH for each time series
log_LH_i = zeros(num_TS, 1);
for i=1:num_TS
%     params_P = struct('k', x0(1), 'theta', avg_t_theta_Q(i) / x0(2), 'sigma', TS_vector_params_Q{i}.sigma, ...
%                       'L', avg_t_L_Q(i) / x0(3), 'mu', avg_t_mu_Q(i) / x0(4), 'dates', datenum('01/01/2000'));
    params_P = [x0(1); avg_t_theta_Q(i)/x0(2); TS_vector_params_Q{i}.sigma; avg_t_L_Q(i)/x0(3); avg_t_mu_Q(i)/x0(4);];
    log_LH_i(i) = TS_likelihood_fixed_params(params_P, TS_vector{i}, 1, 0);
end

% Display summary
log_LH = sum(log_LH_i);
if (display == 1)
    disp(['Avg negative log-LH: ' num2str(mean(log_LH_i))]);
    disp(['Med negative log-LH: ' num2str(median(log_LH_i))]);
    disp(['Min negative log-LH: ' num2str(min(log_LH_i))]);
    disp(['Max negative log-LH: ' num2str(max(log_LH_i))]);
end
disp(['Total negative log-LH: ' num2str(max(log_LH))]);