function TS_new = TS_vector_median(TS_vector)
% --------------------------------------------------------------------------------------------------
% Calculate the median of all currently active time-series.
% --------------------------------------------------------------------------------------------------
% TS_vector        ... cell structure with multiple time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector = {struct('values', [1 5]', 'dates', [732211 732647]'); struct('values', [2.5 3.5]', 'dates', [732210 732648]')}
    TS_vector_median(TS_vector)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS if TS_vector is empty
if (length(TS_vector) == 0)
    TS_new = struct('dates', dates2, 'values', repmat(NaN, length(dates2), 1));
    return;
end

% Synchronize time series
TS_vector = TS_vector_synchronize(TS_vector);

% Extract time series values
num_ts = length(TS_vector);
values_all = zeros(length(TS_vector{1}.values), num_ts);
for i=1:num_ts
    values_all(:, i) = TS_vector{i}.values;
end

% Determine median at each point in time
values = zeros(length(TS_vector{1}.values), 1);
for i=1:length(TS_vector{1}.values)
    values_t = values_all(i,:);
    missing = isnan(values_t);
    if (sum(missing) == num_ts)
        values(i) = NaN;
    else
        values(i) = median(values_t(~missing));
    end
end

% Return time series with median
TS_new = struct('dates', TS_vector{1}.dates, 'values', values);