function TS_matrix = TS_vector_outer_product(TS_vector1, TS_vector2)
% --------------------------------------------------------------------------------------------------
% Take outer product between two TS_vectors and return resulting TS_matrix
% --------------------------------------------------------------------------------------------------
% TS_vector        ... cell structure with multiple time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector = {struct('values', [1 5]', 'dates', [732211 732647]'); struct('values', [2.5 3.5]', 'dates', [732210 732648]')}
    TS_vector_outer_product(TS_vector, TS_vector)
%}
% --------------------------------------------------------------------------------------------------

% Determine size of resulting TS_matrix
num_TS1 = length(TS_vector1);
num_TS2 = length(TS_vector2);
TS_matrix = cell(num_TS1, num_TS2);

% Calculate products of time series
for i=1:num_TS1
    if isempty(TS_vector1{i})
        continue;
    end
    for j=1:num_TS2
        if isempty(TS_vector2{j})
            continue;
        end
        % Take product
        TS_matrix{i,j} = TS_mult_TS(TS_vector1{i}, TS_vector2{j});
    end
end
