function TS_vector_plot(TS_vector, log_scale)
% --------------------------------------------------------------------------------------------------
% Plot a vector of time times series.
% --------------------------------------------------------------------------------------------------
% TS_vector     ... cell structure with time series
% log_sacle     ... indicator whether to plot y-axis on log-scale (not default)
% --------------------------------------------------------------------------------------------------
% sample call: TS_vector_plot(TS_vector)
% --------------------------------------------------------------------------------------------------

if (nargin < 2)
    log_scale = 0;
end

% Define plot parameters
color_matrix = [[0 0 1]; [1 0 0]; [0 1 0]; [1 0 1]; [0 1 1]; [0 0 0]];
line_styles = {'-' '--' ':' '-.' '-' '--' ':' '-.'};
markers = {'none' 'none' 'none' 'none' 'x' 'x' 'x' 'x'};
num_ts = length(TS_vector);

% Determine maximum date range
all_dates = TS_vector{1}.dates;
all_values = TS_vector{1}.values;
for i=1:num_ts
    if (isempty(TS_vector{i}))
        continue;
    end
    all_dates = union_sorted_c(all_dates, TS_vector{i}.dates);
    all_values = union(all_values, TS_vector{i}.values);
end
min_date = all_dates(1);

% Make plot
date_scale = TS_vector{1}.dates - min_date;
if (log_scale == 1)
    semilogy(date_scale, TS_vector{1}.values, 'LineWidth', 1.2, 'Color', color_matrix(1,:), 'LineStyle', line_styles{1}, 'Marker', markers{1});
else
    plot(date_scale, TS_vector{1}.values, 'LineWidth', 1.2, 'Color', color_matrix(1,:), 'LineStyle', line_styles{1}, 'Marker', markers{1});    
end
hold on;
for i=2:num_ts
    % Match date scale
    if isempty(TS_vector{i})
        continue;
    end
    date_pos = find(logical(is_member_sorted_c(TS_vector{i}.dates, TS_vector{1}.dates)));
    date_scale_i = date_scale(date_pos);
    type = mod(i-1, 6) + 1;
    if (~isempty(date_scale_i))
        if (log_scale == 1)
            semilogy(date_scale_i, TS_vector{i}.values, 'LineWidth', 1.2, 'Color', color_matrix(type,:), 'LineStyle', line_styles{type}, ...
                'Marker', markers{type});
        else
            plot(date_scale_i, TS_vector{i}.values, 'LineWidth', 1.2, 'Color', color_matrix(type,:), 'LineStyle', line_styles{type}, ...
                'Marker', markers{type});
        end
    end
end
hold off

% Make nice axes & labels
legend_text = {};
for i=1:num_ts
    legend_text{i} = ['TS' num2str(i)];
end
legend(legend_text);
make_nice_axis(gca, all_values);
make_nice_ticks(all_dates, 120);
