function TS_vector_new = TS_vector_synchronize(TS_vector)
% --------------------------------------------------------------------------------------------------
% Synchronize the time series contained in a cell array
% --------------------------------------------------------------------------------------------------
% TS_vector        ... cell structure with multiple time series
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector = {struct('values', [1 5]', 'dates', [732211 732647]'); struct('values', [2.5 3.5]', 'dates', [732210 732648]')};
    TS_vector_synchronize(TS_vector)
%}
% --------------------------------------------------------------------------------------------------

% Do nothing if we have less than two time series
if (length(TS_vector) < 2)
    TS_vector_new = TS_vector;
    return;
end

% Determine all available dates;
all_dates = TS_vector{1}.dates;
for i=2:length(TS_vector)
    all_dates = union_sorted_c(all_dates, TS_vector{i}.dates);
end

% Resample each time series at union of all dates
for i=1:length(TS_vector)
    TS_vector{i} = TS_sample(TS_vector{i}, all_dates);
end
TS_vector_new = TS_vector;