function TS_vector_new = TS_vector_volatility_level(TS_vector, method_ret, method_2nd, param_2nd)
% --------------------------------------------------------------------------------------------------
% Calculate rolling covariance time series of a vector of (usually return-) time series.
% --------------------------------------------------------------------------------------------------
% TS_vector     ... cell structure with multiple time series
% method_ret    ... method by which to calculate returns
%                   1 ... absolute returns
%                   2 ... relative returns
%                   3 ... log_returns
% method_2nd    ... method by which to calculate second moments:
%                   1 = empirical second moment of last 'param_2nd' data points
%                   2 = use exponentially weighted moving average with decay factor 'param_2nd', e.g. 0.95
%                   3 = robust estimator based on median of sqrt(abs(values1*value2)) during last
%                   'param_2nd' days
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    TS_vector_volatility(TS_vector_CDS, 3, 5, 40)
%}
% --------------------------------------------------------------------------------------------------

% Return empty TS_vector if TS_vector is empty
if isempty(TS_vector)
    TS_vector_new = {};
    return;
end

% Calculate volatility time series matrix
num_ts = length(TS_vector);
TS_vector_new = cell(num_ts, 1);
for i=1:num_ts
    TS_vector_new{i} = TS_volatility_level(TS_vector{i}, method_ret, method_2nd, param_2nd);
end