function TS_new = TS_volatility_level(TS, method_ret, method_2nd, param_2nd)
% --------------------------------------------------------------------------------------------------
% Calculate a volatility time series for the changes of a time series: First calculate returns, then
% calculate rolling volatility estimate
% --------------------------------------------------------------------------------------------------
% TS        ... structure with values and dates
% method_ret    ... method by which to calculate returns
%                   1 ... absolute returns
%                   2 ... relative returns
%                   3 ... log_returns
% method_2nd    ... 1 = moving average of length 'param'
%                   2 = exponentially weighted moving average with decay factor 'param', e.g. 0.95
%                   3 = robust estimator based on median of absolute returns during last 'param' days
%                   4 = same as 1, but take delta_t into account
%                   5 = estimate of continuous volatility via bi-power variation & taking delta_t into account
% --------------------------------------------------------------------------------------------------
% sample call:
%{
    test1=TS_volatility_level(TS1, 3, 1, 40)
    test2=TS_volatility_level(TS1, 3, 2, 0.975)
    test3=TS_volatility_level(TS1, 3, 3, 40)
%}
% --------------------------------------------------------------------------------------------------

% Conver time series into return time series
TS = TS_return(TS, method_ret);

% Volatility estimate based on moving average of squared returns
TS_new = TS_volatility(TS, method_2nd, param_2nd);